<?php
/**
 * This code is licensed under AGPLv3 license or Afterlogic Software License
 * if commercial version of the product was purchased.
 * For full statements of the licenses see LICENSE-AFTERLOGIC and LICENSE-AGPL3 files.
 */

namespace Aurora\Modules\S3Filestorage;

use Aurora\System\SettingsProperty;

/**
 * @property bool $Disabled
 * @property string $AccessKey
 * @property string $SecretKey
 * @property string $Region
 * @property string $Host
 * @property string $BucketPrefix
 * @property string $BucketLocation
 * @property int $PresignedLinkLifetimeMinutes
 * @property bool $RedirectToOriginalFileURLs
 * @property bool $UsePathStyleEndpoint
 */

class Settings extends \Aurora\System\Module\Settings
{
    protected function initDefaults()
    {
        $this->aContainer = [
            "Disabled" => new SettingsProperty(
                false,
                "bool",
                null,
                "Setting to true disables the module",
            ),
            "AccessKey" => new SettingsProperty(
                "",
                "string",
                null,
                "S3 storage access key",
            ),
            "SecretKey" => new SettingsProperty(
                "",
                "string",
                null,
                "S3 storage secret key",
            ),
            "Region" => new SettingsProperty(
                "",
                "string",
                null,
                "S3 storage region. For AWS S3, specify region value. For other S3-compatible services, for instance DigitalOcean Spaces, set to us-east-1 .",
            ),
            "Host" => new SettingsProperty(
                "",
                "string",
                null,
                "S3 storage hostname. For AWS S3, leave empty. For other S3-compatible services set to your endpoint value (e.g.: nyc1.digitaloceanspaces.com for Digital Ocean Spaces).",
            ),
            "BucketPrefix" => new SettingsProperty(
                "",
                "string",
                null,
                "Bucket prefix you wish to be used",
            ),
            "BucketLocation" => new SettingsProperty(
                "",
                "string",
                null,
                "By specifying a specific location (e.g., EUROPE-WEST6), the bucket will be created as a regional bucket, not a multi-region bucket.",
            ),
            "PresignedLinkLifetimeMinutes" => new SettingsProperty(
                60,
                "int",
                null,
                "Lifetime of links with authentication token built into those, for use by external services such as OnlyOffice",
            ),
            "RedirectToOriginalFileURLs" => new SettingsProperty(
                true,
                "bool",
                null,
                "If true, files on S3 storage are obtained via redirect to their actual URLs",
            ),
            "UsePathStyleEndpoint" => new SettingsProperty(
                false,
                "bool",
                null,
                "If true, send requests to an S3 path style endpoint"
            ),
        ];
    }
}
